/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import noppes.npcs.CustomRegisters;
import noppes.npcs.api.ICustomElement;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.items.CustomItem;
import noppes.npcs.reflection.item.ItemSwordReflection;
import noppes.npcs.util.Util;

public class CustomWeapon
extends ItemSword
implements ICustomElement {
    protected NBTTagCompound nbtData;
    protected Set<Block> effectiveBlocks = new HashSet<Block>();
    protected float efficiency = 1.0f;
    protected Material collectionMaterial = null;
    protected float speedCollectionMaterial = 1.0f;
    protected ItemStack repairItemStack;
    protected int enchantability = 0;
    private double attackSpeed = -2.4f;

    public CustomWeapon(Item.ToolMaterial material, NBTTagCompound nbtItem) {
        super(material);
        this.nbtData = nbtItem;
        this.setRegistryName("customnpcs", "custom_" + nbtItem.func_74779_i("RegistryName"));
        this.func_77655_b("custom_" + nbtItem.func_74779_i("RegistryName"));
        if (nbtItem.func_150297_b("SpeedAttack", 6)) {
            this.attackSpeed = nbtItem.func_74769_h("SpeedAttack");
        }
        if (nbtItem.func_150297_b("EntityDamage", 6)) {
            ItemSwordReflection.setAttackDamage(this, (float)nbtItem.func_74769_h("EntityDamage"));
        }
        if (nbtItem.func_74762_e("MaxStackDamage") > 1) {
            this.func_77656_e(nbtItem.func_74762_e("MaxStackDamage"));
        }
        if (nbtItem.func_150297_b("CollectionMaterial", 10)) {
            this.collectionMaterial = CustomItem.getMaterial(nbtItem.func_74775_l("collectionMaterial").func_74779_i("Material"));
            this.speedCollectionMaterial = nbtItem.func_74775_l("collectionMaterial").func_74760_g("Speed");
        }
        if (nbtItem.func_150297_b("CollectionBlocks", 9)) {
            for (int i = 0; i < nbtItem.func_150295_c("CollectionBlocks", 8).func_74745_c(); ++i) {
                Block block = Block.func_149684_b((String)nbtItem.func_150295_c("CollectionBlocks", 8).func_150307_f(i));
                if (block == null) continue;
                this.effectiveBlocks.add(block);
            }
        }
        if (nbtItem.func_150297_b("Efficiency", 5)) {
            this.efficiency = nbtItem.func_74760_g("Efficiency");
        }
        this.repairItemStack = nbtItem.func_150297_b("RepairItem", 10) ? new ItemStack(nbtItem.func_74775_l("RepairItem")) : material.getRepairItemStack();
        if (nbtItem.func_150297_b("Enchantability", 3)) {
            this.enchantability = nbtItem.func_74762_e("Enchantability");
        }
        if (nbtItem.func_150297_b("IsFull3D", 1) && nbtItem.func_74767_n("IsFull3D")) {
            this.func_77664_n();
        }
        this.func_77637_a(CustomRegisters.tabItems);
    }

    public boolean func_150897_b(@Nonnull IBlockState blockIn) {
        return blockIn.func_177230_c() == Blocks.field_150321_G || this.collectionMaterial != null && blockIn.func_185904_a() == this.collectionMaterial;
    }

    public float func_150931_i() {
        return ItemSwordReflection.getAttackDamage(this);
    }

    @Override
    public String getCustomName() {
        return this.nbtData.func_74779_i("RegistryName");
    }

    @Override
    public INbt getCustomNbt() {
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(this.nbtData);
    }

    public float func_150893_a(@Nonnull ItemStack stack, @Nonnull IBlockState state) {
        if (state.func_185904_a() == this.collectionMaterial) {
            return this.speedCollectionMaterial;
        }
        if (this.effectiveBlocks.contains(state.func_177230_c())) {
            for (String type : this.getToolClasses(stack)) {
                if (!state.func_177230_c().isToolEffective(type, state)) continue;
                return this.efficiency;
            }
            return this.efficiency;
        }
        if (state.func_177230_c() == Blocks.field_150321_G) {
            return 15.0f;
        }
        return 1.0f;
    }

    public boolean func_82789_a(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        ItemStack mat = this.repairItemStack;
        if (this.repairItemStack.func_190926_b()) {
            mat = ItemSwordReflection.getMaterial(this).getRepairItemStack();
        }
        if (!mat.func_190926_b() && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    @Nonnull
    public Multimap<String, AttributeModifier> func_111205_h(@Nonnull EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)ItemSwordReflection.getAttackDamage(this), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", this.attackSpeed, 0));
        }
        return multimap;
    }

    public int func_77619_b() {
        if (this.enchantability > 0) {
            return this.enchantability;
        }
        return super.func_77619_b();
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (tab != CustomRegisters.tabItems && tab != CreativeTabs.field_78027_g) {
            return;
        }
        if (this.nbtData != null && this.nbtData.func_150297_b("ShowInCreative", 1) && !this.nbtData.func_74767_n("ShowInCreative")) {
            return;
        }
        items.add((Object)new ItemStack((Item)this));
        if (tab == CustomRegisters.tabItems) {
            Util.instance.sort(items);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return this.field_77789_bW;
    }

    @Override
    public int getType() {
        if (this.nbtData != null && this.nbtData.func_150297_b("BlockType", 1)) {
            return this.nbtData.func_74771_c("BlockType");
        }
        return 1;
    }
}

